
import requests
from bs4 import BeautifulSoup
import os

# Target UIUC database page
URL = "https://m-selig.ae.illinois.edu/ads/coord_database.html"
response = requests.get(URL)
soup = BeautifulSoup(response.content, "html.parser")

# Make output folder
os.makedirs("airfoils_uiuc", exist_ok=True)

# Find all links ending with '.dat'
links = soup.find_all('a')
dat_links = [l.get('href') for l in links if l.get('href') and l.get('href').endswith('.dat')]

print(f"Found {len(dat_links)} airfoil .dat files")

# Download the first 200 airfoils
for i, link in enumerate(dat_links[:200]):
    filename = link.split('/')[-1]
    file_url = f"https://m-selig.ae.illinois.edu/ads/coord/{filename}"
    file_response = requests.get(file_url)

    if file_response.status_code == 200:
        with open(f"airfoils_uiuc/{filename}", "wb") as f:
            f.write(file_response.content)
        print(f"Downloaded {filename} ({i+1}/200)")
    else:
        print(f"Failed to download {filename}")
