
import os
import subprocess

# CONFIG
XFOIL_PATH = "xfoil.exe"  # Use 'xfoil.exe' if it's in your folder
AIRFOIL_DIR = "airfoils_uiuc"
RESULTS_DIR = "results"
ALPHA_START = -5
ALPHA_END = 15
ALPHA_STEP = 1
REYNOLDS = 1000000
MACH = 0.1
TIMEOUT = 20  # seconds

# Make results folder
os.makedirs(RESULTS_DIR, exist_ok=True)

# Loop through airfoils
for filename in os.listdir(AIRFOIL_DIR):
    if not filename.endswith(".dat"):
        continue

    airfoil_name = os.path.splitext(filename)[0]
    dat_file = os.path.join(AIRFOIL_DIR, filename).replace("\\", "/")
    polar_file = os.path.join(RESULTS_DIR, f"{airfoil_name}.pol").replace("\\", "/")

    # Build XFOIL command script with robust blank lines
    xfoil_commands = f"""
LOAD {dat_file}
PANE
OPER
VISC {REYNOLDS}
MACH {MACH}
PACC
{polar_file}

ASEQ {ALPHA_START} {ALPHA_END} {ALPHA_STEP}

PACC
QUIT
"""

    print(f"Running XFOIL for {filename}...")

    try:
        process = subprocess.Popen(
            [XFOIL_PATH],
            stdin=subprocess.PIPE,
            stdout=subprocess.PIPE,
            stderr=subprocess.PIPE,
            universal_newlines=True
        )
        stdout, stderr = process.communicate(xfoil_commands, timeout=TIMEOUT)

        print(f"✅ Processed {filename}: output in {polar_file}")

        if stderr:
            print(f"⚠️ Errors for {filename}:\n{stderr}")

    except subprocess.TimeoutExpired:
        process.kill()
        print(f"⏱️ Timeout: Skipping {filename} (likely bad geometry)")
