
import subprocess
import os

# ✅ Paths
airfoil_dat = "new_airfoils/new_airfoil_shape.dat"
polar_file = "new_airfoils/new_airfoil_shape.pol"

# ✅ XFOIL commands
commands = f"""
LOAD {airfoil_dat}
PANE
OPER
VISC 1000000
MACH 0.1
PACC
{polar_file}

ASEQ -5 15 1
PACC
QUIT
"""

# ✅ Save commands to file (optional, not required)
with open("xfoil_input.in", "w") as f:
    f.write(commands)

# ✅ Run XFOIL
print("Running XFOIL...")
process = subprocess.Popen(
    ["xfoil.exe"],
    stdin=subprocess.PIPE,
    stdout=subprocess.PIPE,
    stderr=subprocess.PIPE
)
stdout, stderr = process.communicate(input=commands.encode())

print("✅ XFOIL run complete")
print(f"Output polar saved to {polar_file}")
