
import torch
import torch.nn as nn
import joblib
import numpy as np
import pandas as pd

# ✅ Load your CSV
df = pd.read_csv("airfoils_geometry_polars_merged.csv")

# ✅ Pick a test row: e.g., the first row
row = df.iloc[0]

# ✅ Extract geometry and AoA
geometry_cols = [c for c in df.columns if "yu_" in c or "yl_" in c]
geometry = row[geometry_cols].values
aoa = np.array([row['Alpha']])  # or set e.g. [5.0]

X_input = np.concatenate([geometry, aoa]).reshape(1, -1)

# ✅ Load scalers
scaler_X = joblib.load("X_scaler.pkl")
scaler_Y = joblib.load("Y_scaler.pkl")

X_scaled = scaler_X.transform(X_input)

# ✅ Define the same model architecture
class SurrogateMLP(nn.Module):
    def __init__(self, input_dim, output_dim):
        super(SurrogateMLP, self).__init__()
        self.net = nn.Sequential(
            nn.Linear(input_dim, 256),
            nn.ReLU(),
            nn.Linear(256, 256),
            nn.ReLU(),
            nn.Linear(256, output_dim)
        )
    def forward(self, x):
        return self.net(x)

# ✅ Load the model weights
model = SurrogateMLP(input_dim=X_scaled.shape[1], output_dim=3)
model.load_state_dict(torch.load("surrogate_model.pt"))
model.eval()

# ✅ Run the prediction
X_tensor = torch.tensor(X_scaled, dtype=torch.float32)
with torch.no_grad():
    Y_scaled = model(X_tensor).numpy()

Y_pred = scaler_Y.inverse_transform(Y_scaled)

print(f"✅ Predicted Cl, Cd, Cm: {Y_pred[0]}")
print(f"✅ True Cl, Cd, Cm: {row[['Cl','Cd','Cm']].values}")
