
import numpy as np

# ✅ Load shape
shape = np.loadtxt("new_airfoils/new_airfoil_shape.csv")

N_POINTS = len(shape) // 2
x = np.linspace(0, 1, N_POINTS)
yu = shape[:N_POINTS]
yl = shape[N_POINTS:]

# ✅ Save as .dat
with open("new_airfoils/new_airfoil_shape.dat", "w") as f:
    f.write("NEW_AIRFOIL\n")
    # Upper: TE -> LE
    for xi, yi in zip(x[::-1], yu[::-1]):
        f.write(f"{xi:.6f} {yi:.6f}\n")
    # Lower: LE -> TE (skip LE point once)
    for xi, yi in zip(x[1:], yl[1:]):
        f.write(f"{xi:.6f} {yi:.6f}\n")

print("✅ Saved new_airfoils/new_airfoil_shape.dat")
