
import os
import csv

RESULTS_DIR = "results"
OUTPUT_CSV = "all_polars_combined.csv"

with open(OUTPUT_CSV, "w", newline="") as csvfile:
    writer = csv.writer(csvfile)
    writer.writerow(["Airfoil", "Alpha", "Cl", "Cd", "Cm", "Top_Xtr", "Bot_Xtr"])

    for pol_file in os.listdir(RESULTS_DIR):
        if not pol_file.endswith(".pol"):
            continue

        airfoil_name = os.path.splitext(pol_file)[0]
        pol_path = os.path.join(RESULTS_DIR, pol_file)

        with open(pol_path, "r") as f:
            for line in f:
                tokens = line.strip().split()
                if len(tokens) == 7:
                    try:
                        row = [airfoil_name] + [float(t) for t in tokens]
                        writer.writerow(row)
                    except ValueError:
                        continue

print(f"✅ Combined .pol files saved to {OUTPUT_CSV}")
