
import os

RESULTS_DIR = "results"

# Loop through all .pol files in results
for pol_file in os.listdir(RESULTS_DIR):
    if not pol_file.endswith(".pol"):
        continue

    pol_path = os.path.join(RESULTS_DIR, pol_file)

    with open(pol_path, "r") as f:
        lines = f.readlines()

    # Identify lines with actual numeric data
    data_lines = [line for line in lines if line.strip() and line.strip()[0].isdigit()]

    if len(data_lines) == 0:
        print(f"❌ {pol_file} is empty or invalid — deleting...")
        os.remove(pol_path)
    else:
        print(f"✅ {pol_file} looks valid with {len(data_lines)} AoA points.")
